package w83b.w83bOperacionesPaso.w83bHistoricos;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import w83b.w83bBeans.W83bHistoricosBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bOperacionesPaso.w83bResultados.W83bTablaCuadroResultadosExcelAction;
import w83b.w83bUtilidades.W83bClsEstilosExcel;
import w83b.w83bUtilidades.W83bUtilidadesExcel;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bClsTrazas;
import w83b.w83bUtilidadesComunes.W83bUtilidades;
import w83b.w83bUtilidadesComunes.W83bUtilidadesN38API;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;



public class W83bCrearCuadroResumenHistAction  extends Q70ActionPasoOP{
	
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		
	}
	

	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		String idioma = (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);

		String strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLAS_EXCEL")+"plantillaExcelw83bHistCuadroResultados.xls";
		InputStream inputStream = W83bTablaCuadroResultadosExcelAction.class.getResourceAsStream(strRutaExcel);
		HSSFWorkbook wb = new HSSFWorkbook(inputStream);
		
		wb.setSheetName(0,"Hoja1"); // Creacin de la hoja
        HSSFSheet sheet = wb.getSheetAt(0); // Creacin de la hoja
        
        W83bUtilidadesExcel excel = new W83bUtilidadesExcel(wb);
        
        HSSFCellStyle estiloNumero = W83bClsEstilosExcel.estiloNumero(wb);
        HSSFCellStyle estiloNumeroBorde = W83bClsEstilosExcel.estiloNumeroBordeArriba(wb);
        
        List datos = (ArrayList)contexto.get("w83bResultadoHistorico");
        W83bHistoricosBean criteriosBean = (W83bHistoricosBean)datos.get(0);
        List resultado = (ArrayList)datos.get(1);
        
        W83bUtilidadesExcel.crearCabeceraPieEstandar(sheet, idioma,(W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO));      
        
        W83bUsuarioXLNetsBean usuario = (W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO);
        String provincia = W83bUtilidadesN38API.elegirProvinciaDelegacion(usuario.getPerfilXLNets());       
         
        StringBuffer tituloImagenEu = new StringBuffer();
        StringBuffer tituloImagenEs = new StringBuffer();
        
        tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloImagenInforme_eu",idioma));
        tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloImagenInforme_es",idioma));
        
        HSSFRow row1 = sheet.getRow((short)4); 
        HSSFCell cell = row1.getCell((short)5);
        cell.setCellValue(tituloImagenEu.toString());
        
        cell = row1.getCell((short)9); 
        cell.setCellValue(tituloImagenEs.toString());
        
        tituloImagenEu = new StringBuffer();
        tituloImagenEs = new StringBuffer();
        
        
        if(W83bClsConstantes.CONSTANTE_SERVICIOS_CENTRALES.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.direccionTrabajo_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.direccionTrabajo_es",idioma));
        }
        else if(W83bClsConstantes.CONSTANTE_GIPUZKOA.equals(provincia)){
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionGuipuzcoa_es",idioma));
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionGuipuzcoa_eu",idioma));
        }
        else if(W83bClsConstantes.CONSTANTE_BIZKAIA.equals(provincia)){
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionBizkaia_es",idioma));
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionBizkaia_eu",idioma));
        }
        else if(W83bClsConstantes.CONSTANTE_ALAVA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionAlava_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionAlava_es",idioma));
        }
        
        
        row1 = sheet.getRow((short)6); 
        cell = row1.getCell((short)5);
        cell.setCellValue(tituloImagenEu.toString());
        
        cell = row1.getCell((short)9); 
        cell.setCellValue(tituloImagenEs.toString());
        
        row1 = sheet.getRow((short)9); 
        cell = row1.getCell((short)3);
        StringBuffer titulo = new StringBuffer();
        titulo.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloCuadroResultadosClasif_eu",idioma));
        titulo.append(" ");
        titulo.append("/");
        titulo.append(" ");
        titulo.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloCuadroResultadosClasif_es",idioma));
        cell.setCellValue(titulo.toString());
        
        //MAPEO FORMULARIO
        row1 = sheet.getRow((short)11); 
        cell = row1.getCell((short)0); 
       
        if (criteriosBean.getTerritorio()== null || "".equals(criteriosBean.getTerritorio()) || "null".equals(criteriosBean.getTerritorio())){
        	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.comautvascaentero",idioma));
        }
        else{
        	cell.setCellValue(criteriosBean.getDescTerritorio().toUpperCase());
        }
        
        row1 = sheet.getRow((short)11);
        
        if(criteriosBean.getPorcentaje()!=null && !"".equals(criteriosBean.getPorcentaje())){
	        cell = row1.getCell((short)2); 
	        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.historicos.porcentajeSobreTotal",idioma)+": "+criteriosBean.getPorcentaje()+"%");
	        
        }
        
        
        row1 = sheet.createRow((short)13); 
        cell = row1.createCell((short)1); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.datosgenerales",idioma));
        
        cell = row1.createCell((short)8); 
        cell.setCellValue(criteriosBean.getMes()+"/"+criteriosBean.getAnyo());
        
        row1 = sheet.createRow((short)15); 
        cell = row1.createCell((short)1);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.numempresas",idioma));
        
        cell = row1.createCell((short)3);
        cell.setCellValue(W83bUtilidades.numero(criteriosBean.getTotEmpresas()));
        cell.setCellStyle(estiloNumero);
        
        cell = row1.createCell((short)10);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.numcentros",idioma));

        cell = row1.createCell((short)12);
        cell.setCellValue(Integer.parseInt(criteriosBean.getTotCentros()));
        cell.setCellStyle(estiloNumero);
     
        row1 = sheet.createRow((short)16); 
        cell = row1.createCell((short)1); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.totalelectores",idioma));
        cell = row1.createCell((short)3);
        cell.setCellValue(Integer.parseInt(criteriosBean.getTotElectores()));
        cell.setCellStyle(estiloNumero);

        cell = row1.createCell((short)5); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.totalvotantes",idioma));
        
        cell = row1.createCell((short)7);
        cell.setCellValue(Integer.parseInt(criteriosBean.getTotVotantes()));
        cell.setCellStyle(estiloNumero);
        
        cell = row1.createCell((short)10); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.porcentaje",idioma));

        cell = row1.createCell((short)12);
        float p=porcentaje(Integer.parseInt(criteriosBean.getTotVotantes()),Integer.parseInt(criteriosBean.getTotElectores()));
        if (Integer.parseInt(criteriosBean.getTotElectores())!=0){
        	cell.setCellValue(p);
        }else{
        	cell.setCellValue(0);
        }
        cell.setCellStyle(stylePorcentajesDcha(excel));
        
        
        row1 = sheet.createRow((short)18); 
        cell = row1.createCell((short)1); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.numdeleg",idioma));
        
        row1 = sheet.createRow((short)20); 
        cell = row1.createCell((short)1); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.hasta49",idioma));
        cell = row1.createCell((short)2); 
        cell.setCellValue(Integer.parseInt(criteriosBean.getHasta49()));
        cell.setCellStyle(estiloNumero);
       
        cell = row1.createCell((short)4); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.demasde49",idioma));
        cell = row1.createCell((short)5); 
        cell.setCellValue(Integer.parseInt(criteriosBean.getMas49()));
        cell.setCellStyle(estiloNumero);
        
        cell = row1.createCell((short)9); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.total",idioma).toUpperCase());
        cell = row1.createCell((short)10); 
        cell.setCellValue(Integer.parseInt(criteriosBean.getTotDel()));
        cell.setCellStyle(estiloNumero);
        
        row1 = sheet.createRow((short)22); 
        cell = row1.createCell((short)3); 
        cell.setCellValue("*"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.rescentrales",idioma)+"*");
            	
        
        if (criteriosBean.getTerritorio()!=null&&!"null".equals(criteriosBean.getTerritorio())&&!"".equals(criteriosBean.getTerritorio())){
        	row1 = sheet.createRow((short)23); 
	    	cell = row1.createCell((short)8); 
	        sheet.addMergedRegion(new Region(23,(short)8,23,(short)10)); 
	        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.representantes",idioma));
	        
	        row1 = sheet.createRow((short)24); 
	        cell = row1.createCell((short)1); 
	        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.central",idioma));
	        cell.setCellStyle(bordeAbajo(excel));
	        cell = row1.createCell((short)2); 
	        cell.setCellStyle(bordeAbajo(excel));
	        cell = row1.createCell((short)3); 
	        cell.setCellStyle(bordeAbajo(excel));
	        cell = row1.createCell((short)4); 
	        cell.setCellStyle(bordeAbajo(excel));
	        cell = row1.createCell((short)5); 
	        cell.setCellStyle(bordeAbajo(excel));
	        cell = row1.createCell((short)6);
	        cell.setCellStyle(bordeAbajo(excel));
	        cell = row1.createCell((short)8); 
	        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.func",idioma));
	        cell.setCellStyle(bordeAbajo(excel));
	        cell = row1.createCell((short)9); 
	        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.labo",idioma));
	        cell.setCellStyle(bordeAbajo(excel));
	        cell = row1.createCell((short)10); 
	        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.tot",idioma));
	        cell.setCellStyle(bordeAbajo(excel));
	        cell = row1.createCell((short)11); 
	        cell.setCellValue("%");
	        cell.setCellStyle(styleCentradoSubrayado(excel));
	        
	        Integer totDel = new Integer(criteriosBean.getTotDel());
	        
	        W83bHistoricosBean elDato = new W83bHistoricosBean();
	        Map mapa = new HashMap();
	        String numero;
	        int totalLineaTerritorio;
	        int totalTerritorio=0;
	        int totalTerritorioFunc=0;
	        int totalTerritorioLabo=0;
	        int fila =26;
	        for (int i=0;i<resultado.size();i++){
	        	elDato =  (W83bHistoricosBean)resultado.get(i);
	        	mapa = (HashMap)elDato.getMap();
	        	totalLineaTerritorio=0;
		        //en la 27 empiezan los datos
	        	
	        	numero = (String)mapa.get(elDato.getSiglas()+"1"+elDato.getTerritorio());
	        	String numero2 = (String)mapa.get(elDato.getSiglas()+"0"+elDato.getTerritorio());     
	        	
	        	if((numero==null  ) && (numero2==null )){
	        		W83bClsTrazas.trazaDebug(null,"no hay dato");
	        	}else{
	        		row1 = sheet.createRow((short)fila); 
			        cell = row1.createCell((short)1);
			        if("OTROS".equals(elDato.getSiglas())){
			        	cell.setCellValue("");
			        	elDato.setDescSindiCas("OTROS");
			        	elDato.setDescSindiEus("OTROS");
			        }else{
			        	cell.setCellValue(elDato.getSiglas());
			        }
			        cell = row1.createCell((short)2);
			        if("es".equals(idioma)){
			        	cell.setCellValue(elDato.getDescSindiCas());
			        }else{
			        	cell.setCellValue(elDato.getDescSindiEus());
			        }
			        
			        cell = row1.createCell((short)8);
			       
			        if(numero==null || ("").equals(numero)){
			        	numero="0";
			        }
			        cell.setCellValue(Integer.parseInt(numero));
			        cell.setCellStyle(estiloNumero);
			        totalLineaTerritorio = Integer.parseInt(numero);
			        totalTerritorioFunc = totalTerritorioFunc+Integer.parseInt(numero);
			        
			        cell = row1.createCell((short)9);
			        numero = (String)mapa.get(elDato.getSiglas()+"0"+elDato.getTerritorio());
			        if(numero==null || ("").equals(numero)){
			        	numero="0";
			        }
			        cell.setCellValue(Integer.parseInt(numero));
			        cell.setCellStyle(estiloNumero);
			        
			        totalLineaTerritorio=Integer.parseInt(numero)+totalLineaTerritorio;
			        totalTerritorioLabo = totalTerritorioLabo+Integer.parseInt(numero);
			        totalTerritorio = totalTerritorio+totalLineaTerritorio;
			        
			        cell = row1.createCell((short)10);
			        cell.setCellValue(Integer.parseInt(totalLineaTerritorio+""));
			        cell.setCellStyle(estiloNumero);
			        
			        cell = row1.createCell((short)11);
			        cell.setCellValue(porcentaje(totalLineaTerritorio,totDel.intValue()));
			        cell.setCellStyle(stylePorcentajesDcha(excel));
			        
			        mapa.remove(elDato.getSiglas()+"1"+elDato.getTerritorio());
			        mapa.remove(elDato.getSiglas()+"0"+elDato.getTerritorio());
	        	
			        fila++;
	        	}  
	        		       
	        }
	        
	        cell = row1.getCell((short)1);
	        cell.setCellStyle(bordeAbajo(excel));
	        cell = row1.getCell((short)2);
	        cell.setCellStyle(bordeAbajo(excel));
	        cell = row1.createCell((short)3);
	        cell.setCellStyle(bordeAbajo(excel));
	        cell = row1.createCell((short)4);
	        cell.setCellStyle(bordeAbajo(excel));
	        cell = row1.createCell((short)5);
	        cell.setCellStyle(bordeAbajo(excel));
	        cell = row1.createCell((short)6);
	        cell.setCellStyle(bordeAbajo(excel));
	        cell = row1.getCell((short)8);
	        cell.setCellStyle(bordeAbajo(excel));
	        cell = row1.getCell((short)9);
	        cell.setCellStyle(bordeAbajo(excel));
	        cell = row1.getCell((short)10);
	        cell.setCellStyle(bordeAbajo(excel));
	    	
	    	row1 = sheet.createRow((short)fila); 
	    	cell = row1.createCell((short)1);
	        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.total",idioma).toUpperCase());
	        cell = row1.createCell((short)8);
	        cell.setCellValue(Integer.parseInt(totalTerritorioFunc+""));
	        cell.setCellStyle(estiloNumero);
	        cell = row1.createCell((short)9);
	        cell.setCellValue(Integer.parseInt(totalTerritorioLabo+""));
	        cell.setCellStyle(estiloNumero);
	        cell = row1.createCell((short)10);
	        cell.setCellValue(Integer.parseInt(totalTerritorio+""));
	        cell.setCellStyle(estiloNumero);
        }else{
        	row1 = sheet.createRow((short)23); 
            cell = row1.createCell((short)2); 
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.araba",idioma));
            cell = row1.createCell((short)6); 
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.gipuzkoa",idioma));
            cell = row1.createCell((short)10); 
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.bizkaia",idioma));
            cell = row1.createCell((short)14); 
          
            sheet.addMergedRegion(new Region(23,(short)14,23,(short)15));
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.comautvasca",idioma));
            row1 = sheet.createRow((short)24); 
            cell = row1.createCell((short)1);     
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.delegados",idioma).toUpperCase());
            cell.setCellStyle(bordeAbajoCentrado(wb));
            cell = row1.createCell((short)2);     
            cell.setCellStyle(bordeAbajoCentrado(wb));
            cell = row1.createCell((short)3);     
            cell.setCellStyle(bordeAbajoCentrado(wb));
            sheet.addMergedRegion(new Region(24,(short)1,24,(short)3)); 
        
            cell = row1.createCell((short)5);       
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.delegados",idioma).toUpperCase());
            cell.setCellStyle(bordeAbajoCentrado(wb));
            cell = row1.createCell((short)6);     
            cell.setCellStyle(bordeAbajoCentrado(wb));
            cell = row1.createCell((short)7);     
            cell.setCellStyle(bordeAbajoCentrado(wb));
            sheet.addMergedRegion(new Region(24,(short)5,24,(short)7)); 
         
            cell = row1.createCell((short)9);  
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.delegados",idioma).toUpperCase());
            cell.setCellStyle(bordeAbajoCentrado(wb));
            cell = row1.createCell((short)10);     
            cell.setCellStyle(bordeAbajoCentrado(wb));
            cell = row1.createCell((short)11);     
            cell.setCellStyle(bordeAbajoCentrado(wb));
            sheet.addMergedRegion(new Region(24,(short)9,24,(short)11)); 
        
            cell = row1.createCell((short)13);                    
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.delegados",idioma).toUpperCase());
            cell.setCellStyle(bordeAbajoCentrado(wb));
            cell = row1.createCell((short)14);     
            cell.setCellStyle(bordeAbajoCentrado(wb));
            cell = row1.createCell((short)15);     
            cell.setCellStyle(bordeAbajoCentrado(wb));
            sheet.addMergedRegion(new Region(24,(short)13,24,(short)15)); 
         
            row1 = sheet.createRow((short)25); 
            cell = row1.createCell((short)0); 
            cell.setCellStyle(bordeAbajo(excel));
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.central",idioma));
            cell = row1.createCell((short)1); 
            cell.setCellStyle(bordeAbajo(excel));
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.publ",idioma));
            cell = row1.createCell((short)2); 
            cell.setCellStyle(bordeAbajo(excel));
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.priv",idioma));
            cell = row1.createCell((short)3); 
            cell.setCellStyle(bordeAbajo(excel));
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.tot",idioma));
            cell = row1.createCell((short)4); 
            cell.setCellStyle(styleCentradoSubrayado(excel));
            cell.setCellValue("%");
            cell = row1.createCell((short)5); 
            cell.setCellStyle(bordeAbajo(excel));
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.publ",idioma));
            cell = row1.createCell((short)6);
            cell.setCellStyle(bordeAbajo(excel));
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.priv",idioma));
            cell = row1.createCell((short)7); 
            cell.setCellStyle(bordeAbajo(excel));
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.tot",idioma));
            cell = row1.createCell((short)8);
            cell.setCellStyle(styleCentradoSubrayado(excel));
            cell.setCellValue("%");
            cell = row1.createCell((short)9); 
            cell.setCellStyle(bordeAbajo(excel));
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.publ",idioma));
            cell = row1.createCell((short)10); 
            cell.setCellStyle(bordeAbajo(excel));
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.priv",idioma));
            cell = row1.createCell((short)11); 
            cell.setCellStyle(bordeAbajo(excel));
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.tot",idioma));
            cell = row1.createCell((short)12); 
            cell.setCellStyle(styleCentradoSubrayado(excel));
            cell.setCellValue("%");
            cell = row1.createCell((short)13); 
            cell.setCellStyle(bordeAbajo(excel));
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.publ",idioma));
            cell = row1.createCell((short)14); 
            cell.setCellStyle(bordeAbajo(excel));
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.priv",idioma));
            cell = row1.createCell((short)15); 
            cell.setCellStyle(bordeAbajo(excel));
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.tot",idioma));
            cell = row1.createCell((short)16); 
            cell.setCellStyle(styleCentradoSubrayado(excel));
            cell.setCellValue("%");
           
	        
	        W83bHistoricosBean elDato = new W83bHistoricosBean();
	        String numero;
	        Map mapa = new HashMap();
	       
	        int totalLineaTerritorio;
	        int totalTerritorio=0;
	        int totalTerritorioLabo=0;
	        int totalTerritorioFunc=0;
	        
	        int totalTerritorioLaboAlava=0;
	        int totalTerritorioLaboGipuzkoa=0;
	        int totalTerritorioLaboBizkaia=0;
	        int totalTerritorioFuncAlava=0;
	        int totalTerritorioFuncGipuzkoa=0;
	        int totalTerritorioFuncBizkaia=0;
	     
	        int fila =26;
	        
	        Integer delAlava = new Integer(criteriosBean.getTotDelAlava());
	        Integer delGipuzkoa = new Integer(criteriosBean.getTotDelGipuzkoa());
	        Integer delBizkaia = new Integer(criteriosBean.getTotDelBizkaia());
	        Integer delTotal = new Integer(delAlava.intValue()+delBizkaia.intValue()+delGipuzkoa.intValue());
	        
	        for (int i=0;i<resultado.size();i++){
	        	
	        	totalTerritorio=0;
		        totalTerritorioLabo=0;
		        totalTerritorioFunc=0;	
	        	
	        	boolean saltarLinea1 = false;
		        boolean saltarLinea2 = false;
		        boolean saltarLinea3 = false;
		        	        
	        	
	        	elDato =  (W83bHistoricosBean)resultado.get(i);
	        	mapa = (HashMap)elDato.getMap();
	        	totalLineaTerritorio=0;
		        //en la 27 empiezan los datos
	        	
	        	row1 = sheet.createRow((short)fila); 
		        cell = row1.createCell((short)0);
		        cell.setCellValue(elDato.getSiglas());
	        	
	        	//LAVA
	        	numero = (String)mapa.get(elDato.getSiglas()+"11");
	        	String numero2 = (String)mapa.get(elDato.getSiglas()+"01");
	        	
	        	if((numero==null  ) && (numero2==null )){
	        		 cell = row1.createCell((short)1);
	        		 cell.setCellValue(0);
	        		 cell = row1.createCell((short)2);
	        		 cell.setCellValue(0);
	        		 cell = row1.createCell((short)3);
	        		 cell.setCellValue(0);
	        		 cell = row1.createCell((short)4);
	        		 cell.setCellValue(0);
	        		 
	        		 saltarLinea1 = true;
	        	}else{
	        		
			        cell = row1.createCell((short)1);
			       
			        if(numero==null || ("").equals(numero)){
			        	numero="0";
			        }
			        cell.setCellValue(Integer.parseInt(numero));
			        cell.setCellStyle(estiloNumero);
			        totalLineaTerritorio = Integer.parseInt(numero);
			        totalTerritorioFunc = totalTerritorioFunc+Integer.parseInt(numero);
			        totalTerritorioFuncAlava = totalTerritorioFuncAlava+Integer.parseInt(numero);
			        
			        cell = row1.createCell((short)2);
			        numero = (String)mapa.get(elDato.getSiglas()+"01");
			        if(numero==null || ("").equals(numero)){
			        	numero="0";
			        }
			        cell.setCellValue(Integer.parseInt(numero));
			        cell.setCellStyle(estiloNumero);
			        
			        totalLineaTerritorio=Integer.parseInt(numero)+totalLineaTerritorio;
			        totalTerritorioLabo = totalTerritorioLabo+Integer.parseInt(numero);
			        totalTerritorioLaboAlava = totalTerritorioLaboAlava+Integer.parseInt(numero);
			        totalTerritorio = totalTerritorio+totalLineaTerritorio;
			        
			        cell = row1.createCell((short)3);
			        cell.setCellValue(Integer.parseInt(totalLineaTerritorio+""));
			        cell.setCellStyle(estiloNumero);
			        
			        cell = row1.createCell((short)4);
			        cell.setCellValue(porcentaje(totalLineaTerritorio,delAlava.intValue()));//NOPMD
			      
			        cell.setCellStyle(stylePorcentajesDcha(excel));
			        
			        mapa.remove(elDato.getSiglas()+"11");
			        mapa.remove(elDato.getSiglas()+"01");
	        	
	        	}  
	        	
	        	//GIPUZKOA
	        	numero = (String)mapa.get(elDato.getSiglas()+"120");
	        	 numero2 = (String)mapa.get(elDato.getSiglas()+"020");
	        	 totalLineaTerritorio=0;
	        	
	        	if((numero==null  ) && (numero2==null )){
	        		 cell = row1.createCell((short)5);
	        		 cell.setCellValue(0);
	        		 cell = row1.createCell((short)6);
	        		 cell.setCellValue(0);
	        		 cell = row1.createCell((short)7);
	        		 cell.setCellValue(0);
	        		 cell = row1.createCell((short)8);
	        		 cell.setCellValue(0);
	        		 saltarLinea2 = true;
	        	}else{
	        					        
			        cell = row1.createCell((short)5);
			       
			        if(numero==null || ("").equals(numero)){
			        	numero="0";
			        }
			        cell.setCellValue(Integer.parseInt(numero));
			        cell.setCellStyle(estiloNumero);
			        totalLineaTerritorio = Integer.parseInt(numero);
			        totalTerritorioFunc = totalTerritorioFunc+Integer.parseInt(numero);
			        totalTerritorioFuncGipuzkoa = totalTerritorioFuncGipuzkoa+Integer.parseInt(numero);
			        
			        cell = row1.createCell((short)6);
			        numero = (String)mapa.get(elDato.getSiglas()+"020");
			        if(numero==null || ("").equals(numero)){
			        	numero="0";
			        }
			        cell.setCellValue(Integer.parseInt(numero));
			        cell.setCellStyle(estiloNumero);
			        
			        totalLineaTerritorio=Integer.parseInt(numero)+totalLineaTerritorio;
			        totalTerritorioLabo = totalTerritorioLabo+Integer.parseInt(numero);
			        totalTerritorioLaboGipuzkoa = totalTerritorioLaboGipuzkoa+Integer.parseInt(numero);
			        totalTerritorio = totalTerritorio+totalLineaTerritorio;
			        
			        cell = row1.createCell((short)7);
			        cell.setCellValue(Integer.parseInt(totalLineaTerritorio+""));
			        cell.setCellStyle(estiloNumero);
			        
			        cell = row1.createCell((short)8);
			        cell.setCellValue(porcentaje(totalLineaTerritorio,delGipuzkoa.intValue()));
			        cell.setCellStyle(stylePorcentajesDcha(excel));
			        
			        mapa.remove(elDato.getSiglas()+"120");
			        mapa.remove(elDato.getSiglas()+"020");
	        	
	        	} 
	        	
	        	//BIZKAIA
	        	numero = (String)mapa.get(elDato.getSiglas()+"148");
	        	 numero2 = (String)mapa.get(elDato.getSiglas()+"048");
	        	 totalLineaTerritorio=0;
	        	
	        	if((numero==null  ) && (numero2==null )){
	        		 cell = row1.createCell((short)9);
	        		 cell.setCellValue(0);
	        		 cell = row1.createCell((short)10);
	        		 cell.setCellValue(0);
	        		 cell = row1.createCell((short)11);
	        		 cell.setCellValue(0);
	        		 cell = row1.createCell((short)12);
	        		 cell.setCellValue(0);
	        		 saltarLinea3 = true;
	        	}else{
	        		
			        cell = row1.createCell((short)9);
			       
			        if(numero==null || ("").equals(numero)){
			        	numero="0";
			        }
			        cell.setCellValue(Integer.parseInt(numero));
			        cell.setCellStyle(estiloNumero);
			        totalLineaTerritorio = Integer.parseInt(numero);
			        totalTerritorioFunc = totalTerritorioFunc+Integer.parseInt(numero);
			        totalTerritorioFuncBizkaia = totalTerritorioFuncBizkaia+Integer.parseInt(numero);
			        
			        cell = row1.createCell((short)10);
			        numero = (String)mapa.get(elDato.getSiglas()+"048");
			        if(numero==null || ("").equals(numero)){
			        	numero="0";
			        }
			        cell.setCellValue(Integer.parseInt(numero));
			        cell.setCellStyle(estiloNumero);
			        
			        totalLineaTerritorio=Integer.parseInt(numero)+totalLineaTerritorio;
			        totalTerritorioLabo = totalTerritorioLabo+Integer.parseInt(numero);
			        totalTerritorioLaboBizkaia = totalTerritorioLaboBizkaia+Integer.parseInt(numero);
			        totalTerritorio = totalTerritorio+totalLineaTerritorio;
			        
			        cell = row1.createCell((short)11);
			        cell.setCellValue(Integer.parseInt(totalLineaTerritorio+""));
			        cell.setCellStyle(estiloNumero);
			        
			        cell = row1.createCell((short)12);
			        cell.setCellValue(porcentaje(totalLineaTerritorio,delBizkaia.intValue()));
			        cell.setCellStyle(stylePorcentajesDcha(excel));
			        
			        mapa.remove(elDato.getSiglas()+"148");
			        mapa.remove(elDato.getSiglas()+"048");
	        	
	        	} 
	        	
	        	
	        	    cell = row1.createCell((short)13);
	        	    cell.setCellValue(totalTerritorioFunc);
	        	    cell.setCellStyle(estiloNumero);
	        	    cell = row1.createCell((short)14);
	        	    cell.setCellValue(totalTerritorioLabo);
	        	    cell.setCellStyle(estiloNumero);
	        	    cell = row1.createCell((short)15);
	        	    cell.setCellValue(totalTerritorio);
	        	    cell.setCellStyle(estiloNumero);
	        	    cell = row1.createCell((short)16);
	        	    cell.setCellValue(porcentaje(totalTerritorio, delTotal.intValue()));
	        	    cell.setCellStyle(stylePorcentajesDcha(excel));
			       
	        	
	        	if(!saltarLinea1 || !saltarLinea2 || !saltarLinea3){
	        		fila++;
	        	}
	        		       
	        }
	     
	    	row1 = sheet.createRow((short)fila); 
	    	cell = row1.createCell((short)0);
	        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.total",idioma).toUpperCase());
	        cell.setCellStyle(bordeArriba(excel));
	        cell = row1.createCell((short)1);
	        cell.setCellValue(Integer.parseInt(totalTerritorioFuncAlava+""));
	        cell.setCellStyle(estiloNumeroBorde);
	        cell = row1.createCell((short)2);
	        cell.setCellValue(Integer.parseInt(totalTerritorioLaboAlava+""));
	        cell.setCellStyle(estiloNumeroBorde);
	        cell = row1.createCell((short)3);
	        cell.setCellValue(Integer.parseInt(delAlava+""));
	        cell.setCellStyle(estiloNumeroBorde);
	        cell = row1.createCell((short)4);
	        cell.setCellValue("");
	        cell = row1.createCell((short)5);
	        cell.setCellValue(Integer.parseInt(totalTerritorioFuncGipuzkoa+""));
	        cell.setCellStyle(estiloNumeroBorde);
	        cell = row1.createCell((short)6);
	        cell.setCellValue(Integer.parseInt(totalTerritorioLaboGipuzkoa+""));
	        cell.setCellStyle(estiloNumeroBorde);
	        cell = row1.createCell((short)7);
	        cell.setCellValue(Integer.parseInt(delGipuzkoa+""));
	        cell.setCellStyle(estiloNumeroBorde);
	        cell = row1.createCell((short)8);
	        cell.setCellValue("");
	        cell = row1.createCell((short)9);
	        cell.setCellValue(Integer.parseInt(totalTerritorioFuncBizkaia+""));
	        cell.setCellStyle(estiloNumeroBorde);
	        cell = row1.createCell((short)10);
	        cell.setCellValue(Integer.parseInt(totalTerritorioLaboBizkaia+""));
	        cell.setCellStyle(estiloNumeroBorde);
	        cell = row1.createCell((short)11);
	        cell.setCellValue(Integer.parseInt(delBizkaia+""));
	        cell.setCellStyle(estiloNumeroBorde);
	        cell = row1.createCell((short)12);
	        cell.setCellValue("");
	        cell = row1.createCell((short)13);
	        cell.setCellValue((totalTerritorioFuncAlava+totalTerritorioFuncGipuzkoa+totalTerritorioFuncBizkaia));
	        cell.setCellStyle(estiloNumeroBorde);
	        cell = row1.createCell((short)14);
	        cell.setCellValue((totalTerritorioLaboAlava+totalTerritorioLaboGipuzkoa+totalTerritorioLaboBizkaia));
	        cell.setCellStyle(estiloNumeroBorde);
	        cell = row1.createCell((short)15);
	        cell.setCellValue(Integer.parseInt(delTotal+""));
	        cell.setCellStyle(estiloNumeroBorde);
	        cell = row1.createCell((short)16);
	        cell.setCellValue("");
        	
        }
        
        byte[] bytesExcel = W83bUtilidadesExcel.fncExcelToBytes(wb);
        
        response.setContentType("application/vnd.ms-excel");
        response.setContentLength(bytesExcel.length);
        response.setHeader("Content-disposition","attachment;filename=listadoCuadroResumenResultados.xls");
        response.getOutputStream().write(bytesExcel);
        response.getOutputStream().flush();

		
		return null;
	}
	
	
	private HSSFCellStyle bordeAbajoCentrado(HSSFWorkbook wb){
		HSSFCellStyle bordeAbajoCentrado =  wb.createCellStyle();
		
		bordeAbajoCentrado = wb.createCellStyle();// Estilo
		bordeAbajoCentrado.setBorderBottom(HSSFCellStyle.BORDER_THIN);
		bordeAbajoCentrado.setAlignment(HSSFCellStyle.ALIGN_CENTER_SELECTION);
		return bordeAbajoCentrado;
		
		
	}
	private HSSFCellStyle bordeAbajo(W83bUtilidadesExcel excel){
		return excel.styleBordeAbajo;			
		
	}
	private HSSFCellStyle bordeArriba(W83bUtilidadesExcel excel){
		return excel.styleBordeArriba;			
		
	}
	
	
	private HSSFCellStyle stylePorcentajesDcha(W83bUtilidadesExcel excel){
		return excel.stylePorcentajesDcha;			
		
	}
	private HSSFCellStyle styleCentradoSubrayado(W83bUtilidadesExcel excel){
		return excel.styleCentradoSubrayado;			
		
	}
	
	
	
	
	private float porcentaje(int totalParcial,int total){
		
		if (total==0){
			Double d = new Double("0.00");
			return d.floatValue();
		}
		else{
			return((float)totalParcial)/(float)total;			
		}
	}

}